$(function () {
  const API_BASE = 'https://api-public.madnezz.com.br/api/v1/public/sites/novidade';
  const IMG_BASE_ACONTECE = 'https://sites.madnezz.com.br/api/site/upload/Acontece/';
  const IMG_FALLBACK_CARD = 'images/produto_padrao.png';
  const IMG_FALLBACK_DETALHE = 'images/produto_padrao.png';

  const icone_calendar = '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512"><path d="M12 192h424c6.6 0 12 5.4 12 12v260c0 26.5-21.5 48-48 48H48c-26.5 0-48-21.5-48-48V204c0-6.6 5.4-12 12-12zm436-44v-36c0-26.5-21.5-48-48-48h-48V12c0-6.6-5.4-12-12-12h-40c-6.6 0-12 5.4-12 12v52H160V12c0-6.6-5.4-12-12-12h-40c-6.6 0-12 5.4-12 12v52H48C21.5 64 0 85.5 0 112v36c0 6.6 5.4 12 12 12h424c6.6 0 12-5.4 12-12z"/></svg>';
  const icone_text = '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M464 256h-80v-64c0-35.3 28.7-64 64-64h8c13.3 0 24-10.7 24-24V56c0-13.3-10.7-24-24-24h-8c-88.4 0-160 71.6-160 160v240c0 26.5 21.5 48 48 48h128c26.5 0 48-21.5 48-48V304c0-26.5-21.5-48-48-48zm-288 0H96v-64c0-35.3 28.7-64 64-64h8c13.3 0 24-10.7 24-24V56c0-13.3-10.7-24-24-24h-8C71.6 32 0 103.6 0 192v240c0 26.5 21.5 48 48 48h128c26.5 0 48-21.5 48-48V304c0-26.5-21.5-48-48-48z"/></svg>';
  const icone_clock = '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M256 8C119 8 8 119 8 256S119 504 256 504 504 393 504 256 393 8 256 8zm92.5 313h0l-20 25a16 16 0 0 1 -22.5 2.5h0l-67-49.7a40 40 0 0 1 -15-31.2V112a16 16 0 0 1 16-16h32a16 16 0 0 1 16 16V256l58 42.5A16 16 0 0 1 348.5 321z"/></svg>';

  function buildUrl(params) {
    const q = new URLSearchParams();
    if (params.novidade_id) q.set('novidade_id', params.novidade_id);
    if (params.empreendimento_id) q.set('empreendimento_id', params.empreendimento_id);
    if (params.tp != null) q.set('tp', params.tp);
    if (params.ano) q.set('ano', params.ano);
    if (params.mes) q.set('mes', params.mes);
    return `${API_BASE}?${q.toString()}`;
  }

  function normalizarImagemEntrada(valor) {
    if (!valor) return null;
    if (/^https?:\/\//i.test(valor)) {
      return valor.replace(/\/novidade\//i, '/Acontece/');
    }
    return IMG_BASE_ACONTECE + valor;
  }

  function isFuturo(item) {
    if (!item ?.novidade_entrada || item.novidade_entrada.length < 10) return false;
    const dd = item.novidade_entrada.substring(0, 2);
    const mm = parseInt(item.novidade_entrada.substring(3, 5), 10);
    const yyyy = item.novidade_entrada.substring(6, 10);
    const dataEntrada = new Date(`${mm}/${dd}/${yyyy}`);
    const hoje = new Date();
    const hojeSemHora = new Date(`${hoje.getMonth() + 1}/${hoje.getDate()}/${hoje.getFullYear()}`);
    return hojeSemHora < dataEntrada;
  }

  function toSlug(str) {
    return (str || '')
      .toLowerCase()
      .normalize('NFD')
      .replace(/[\u0300-\u036f]/g, '')
      .replaceAll(' ', '-');
  }

  function novidade_info(novidadeId) {
    $('.filtros').hide();
    $('.clube_hide').hide();
    $('#info').show();

    const url = buildUrl({
      novidade_id: novidadeId,
      empreendimento_id: window.shopping_id,
      tp: 4
    });

    $.ajax({
        url,
        dataType: 'json'
      })
      .done(function (data) {
        if (!Array.isArray(data) || !data.length) {
          $('.novidade_info').html("<p class='tac'>Não foi possível carregar os detalhes desta novidade.</p>").show();
          return;
        }

        const item = data[0];

        const imagem =
          normalizarImagemEntrada(item.novidade_imagem_1_url) ||
          normalizarImagemEntrada(item.novidade_imagem_1) ||
          IMG_FALLBACK_DETALHE;

        $('a.clube_nome').text(item.novidade_nome || '');

        const periodoHtml = item.novidade_periodo ?
          `<h3>Período do clube</h3><p><span style="font-weight:400;">${icone_calendar} ${item.novidade_periodo}</span></p>` :
          '';

        const horarioHtml = item.novidade_horario ?
          `<h3>Horário do clube</h3><p><span style="font-weight:400;">${icone_clock} ${item.novidade_horario}</span></p>` :
          '';

        const botaoInscricao = item.novidade_imagem_url ?
          `<a href="${item.novidade_imagem_url}" target="_new" id="btn-validate">Inscreva-se</a>` :
          '';

        $('.novidade_info')
          .html(`
            <div class="imagem">
              <img src="${imagem}" alt="clube ${item.novidade_nome || ''}"/>
            </div>
            <div class="informacoes">
              <h2 class="font-size-45 font-semibold mt-10">${item.novidade_nome || ''}</h2>
              ${periodoHtml}
              ${horarioHtml}
              <h3>Sobre este clube</h3>
              <p class="info_texto esconde">${icone_text} ${item.novidade_texto || ''}</p>
              ${botaoInscricao}
            </div>
          `)
          .show();
      })
      .fail(function () {
        $('.novidade_info').html("<p class='tac'>Não foi possível carregar os detalhes desta novidade.</p>").show();
      });
  }

  function novidades() {
    const anoSel = $('select.ano').val();
    const mesSel = $('select.mes').val();

    let url;
    if (anoSel && mesSel) {
      url = buildUrl({
        ano: anoSel,
        mes: mesSel,
        empreendimento_id: window.shopping_id,
        tp: 4
      });
    } else if (anoSel) {
      url = buildUrl({
        ano: anoSel,
        empreendimento_id: window.shopping_id,
        tp: 4
      });
    } else {
      url = buildUrl({
        empreendimento_id: window.shopping_id,
        tp: 4
      });
    }

    if (window.novidade_id) {
      novidade_info(window.novidade_id);
      return;
    }

    $.ajax({
        url,
        dataType: 'json'
      })
      .done(function (data) {
        const $lista = $('.clube_lista').first();
        if (Array.isArray(data) && data.length) {
          $lista.empty();
          $('.novidade_qtd').empty();
          $('.filtros').css('display', 'flex');
          $('.clube_hide').css('display', 'block');
          $('.novidade_info').hide();

          data.forEach(function (e) {
            const imagem =
              normalizarImagemEntrada(e.novidade_imagem_1_url) ||
              normalizarImagemEntrada(e.novidade_imagem_1) ||
              IMG_FALLBACK_CARD;

            const nome = e.novidade_nome || '';
            const nomeCurto = nome.length > 40 ? (nome.substring(0, 40) + '...') : nome;
            const slug = toSlug(nome);
            const id = e.novidade_id;

            if (!isFuturo(e)) {
              const textoLimpo = e.novidade_texto ?
                $('<div>').html(e.novidade_texto).text() :
                '';

              $lista.append(`
                <div class="clube-item" data-url="${slug}" data-id="${id}">
                  <img class="imagem" src="${imagem}" alt="${nome}">
                  <h2 class="informacoes"><span class="titulo">${nomeCurto}</span></h2>
                  ${textoLimpo ? `<p class="clube-texto">${textoLimpo}</p>` : ''}
                </div>
              `);
            }
          });

          setTimeout(function () {
            if (window.novidade_url) {
              const $el = $(document).find(`[data-url="${window.novidade_url}"]`);
              if ($el.length) $el.click();
              else $('#lista').show();
            } else {
              $('#lista').show();
            }
          }, 100);
        } else {
          $('.clube_lista').empty();
          $('.novidade_qtd').html("<p class='tac'>Nenhuma ocorrência encontrada!</p>");
        }
      })
      .fail(function () {
        $('.clube_lista').empty();
        $('.novidade_qtd').html("<p class='tac'>Erro ao carregar clube.</p>");
      });
  }

  novidades();

  $('.ano,.mes').on('change', function () {
    $('.novidade_info,.novidade_img').hide();
    window.novidade_id = '';
    novidades();
  });

  $(document).on('click', '.leia_mais', function () {
    if ($('.info_texto.esconde').length > 0) {
      $('.info_texto').removeClass('esconde');
      $('.leia_mais').text('Leia menos');
    } else {
      $('.info_texto').addClass('esconde');
      $('.leia_mais').text('Leia mais');
    }
  });

  $(document).on('click', '[data-url]', function () {
    novidade_info(+$(this).data('id'));
  });
});